#include "ADC.h"

void ADC_Init12b(UINT16 activeChannelsMask)
{
    ADCCFG1_MODE = 0x01; //12 bit conversion mode
  	ADCSC2 = 0x00;       //software trigger, compare function disabled, default voltege reference pin pair
  	ADCSC1A = ADCSC1A_ADCHA_MASK;	//disable channels
    APCTL1 = activeChannelsMask & 0x00FF;
    APCTL2 = activeChannelsMask >> 8;
}


void ADC_Init8b(UINT16 activeChannelsMask)
{
    ADCCFG1_MODE = 0x00; //8 bit conversion mode
  	ADCSC2 = 0x00;
  	ADCSC1A = ADCSC1A_ADCHA_MASK;  ///*31
    APCTL1 = activeChannelsMask & 0x00FF;
    APCTL2 = activeChannelsMask >> 8;
}


UINT16 ADC_Read12b(UINT8 channelNumber)
{
	ADCSC1A = channelNumber & ADCSC1A_ADCHA_MASK;	/* Write to ADCSC1 to start conversion */
	while (ADCSC2_ADACT == 1); 				  	/* Wait if the conversion is in progress */
	while (ADCSC1A_COCOA == 0); 					/* Wait until the conversion is complete */
	return ADCRA; /* */
}


UINT8 ADC_Read8b(UINT8 channelNumber)
{
	ADCSC1A = channelNumber & ADCSC1A_ADCHA_MASK;	/* Write to ADCSC1 to start conversion */
	while (ADCSC2_ADACT == 1); 				  	/* Wait if the conversion is in progress */
	while (ADCSC1A_COCOA == 0); 					/* Wait until the conversion is complete */
	return ADCRLA; /* */
}
